Review Article

# Mycobiome in the Gut: A Multiperspective Review

Voon Kin Chin , 1 Voon Chen Yong,1 Pei Pei Chong,1 Syafinaz Amin Nordin , 2 Rusliza Basir , 3 and Maha Abdullah $\textcircled { 1 0 } ^ { 4 }$

1 School of Biosciences, Faculty of Health and Medical Sciences, Taylor’s University Lakeside Campus, 47500 Subang Jaya, Malaysia   
2 Department of Medical Microbiology and Parasitology, Faculty of Medicine and Health Sciences, Universiti Putra Malaysia,   
43400 Serdang, Selangor, Malaysia   
3 Department of Human Anatomy, Faculty of Medicine and Health Sciences, Universiti Putra Malaysia, 43400 Serdang,   
Selangor, Malaysia   
4 Department of Pathology, Faculty of Medicine and Health Sciences, Universiti Putra Malaysia, 43400 Serdang, Selangor, Malaysia

Correspondence should be addressed to Maha Abdullah; maha@upm.edu.my

Received 6 September 2019; Revised 23 February 2020; Accepted 17 March 2020; Published 4 April 2020

Academic Editor: Elisabetta Buommino

Copyright $^ ©$ 2020 Voon Kin Chin et al. This is an open access article distributed under the Creative Commons Attribution License, which permits unrestricted use, distribution, and reproduction in any medium, provided the original work is properly cited.

Human gut is home to a diverse and complex microbial ecosystem encompassing bacteria, viruses, parasites, fungi, and other microorganisms that have an undisputable role in maintaining good health for the host. Studies on the interplay between microbiota in the gut and various human diseases remain the key focus among many researchers. Nevertheless, advances in sequencing technologies and computational biology have helped us to identify a diversity of fungal community that reside in the gut known as the mycobiome. Although studies on gut mycobiome are still in its infancy, numerous sources have reported its potential role in host homeostasis and disease development. Nonetheless, the actual mechanism of its involvement remains largely unknown and underexplored. Thus, in this review, we attempt to discuss the recent advances in gut mycobiome research from multiple perspectives. This includes understanding the composition of fungal communities in the gut and the involvement of gut mycobiome in host immunity and gut-brain axis. Further, we also discuss on multibiome interactions in the gut with emphasis on fungi-bacteria interaction and the influence of diet in shaping gut mycobiome composition. This review also highlights the relation between fungal metabolites and gut mycobiota in human homeostasis and the role of gut mycobiome in various human diseases. This multiperspective review on gut mycobiome could perhaps shed new light for future studies in the mycobiome research area.

# 1. Introduction

Human gut is a complex ecosystem inhabited by a myriad of microorganisms including bacteria, fungi, archae, and viruses [1]. Thus far, studies on gut bacteria or gut “microbiome” have received the most attention due to the abundance of bacterial flora present in the gut. For example, large-scale projects including Metagenomics of the Human Intestinal Tract (MetaHIT) and National Institutes of Health (NIH) Human Microbiome Project (HMP) were among the projects that were initiated to study the composition of bacterial flora and their impacts on human health [1, 2]. Nevertheless, the shift in focus towards the “rare biosphere” [3] in the gut, particularly on fungi, has gathered increasing traction nowadays. Studies on “mycobiome,” a term used to describe the fungal community of the microbiome, have escalated despite still being in its infancy stage as it may be significant in the context of human health and diseases [4].

The studies on human gut mycobiome have received little attention for the past decades because fungal presence is relatively insignificant in the gut compared to the bacterial communities. In addition to that, fungi have been traditionally studied by culture-dependent methods [5, 6], which limits the in-depth understanding of the fungal microbiota. Nonetheless, recent advances in deep-sequencing technologies and bioinformatics analysis have shed light on the complexity of the fungal communities that reside on both mucosal and luminal surfaces in the gut and further highlighted our current understanding on this poorly understood compartment that reside in the gut. Increasing evidences have demonstrated the undisputable role of fungal components in driving the pathogenesis of various gut-associated and metabolic diseases [7–9]. In addition to that, specific fungi possess the ability to modulate host immune response and could be a risk factor for immunological disorders seen in genetically susceptible individuals [10]. More profoundly, gut mycobiome could be the reservoir for opportunistic pathogens in immunocompromised hosts [11–13]. These clearly indicate that gut mycobiome is crucial in host homeostasis and disease development. Thus, in this review, we seek to summarize the role of gut mycobiota from multiple perspectives and to highlight the latest research on gut mycobiome on disease development, in order to provide new insights and productive direction for future studies in this newly emerged research area.

# 2. Fungal Communities in Gut

In general, fungi constitute a minor component of the entire gut microbiome. Recent shotgun metagenomics sequencing analysis has revealed that fungi consist of nearly $0 . 1 \%$ of the total microbes in the gut [1, 14]. On the other hand, despite numerous published data on gut mycobiome, the fungal communities in the gut remain poorly understood. There is no consensus in defining a healthy gut mycobiome due to a variety of factors such as low abundance and diversity of fungi in the gut, temporal instability of gut mycobiota throughout the development periods, and high intervolunteer and intravolunteer variability of the gut mycobiome [15, 16]. Nevertheless, the fungal communities in the gut have been highlighted in many studies [8, 16, 17]. In terms of phyla, thus far, most studies have suggested that Ascomycota is the most predominant phylum found in the gut, followed by Zygomycota and Basidiomycota phyla [15, 18–20]. Meanwhile, in the context of genus, a recent review by Hallen-Adams and coworkers had identified potential fungal species that inhabit the intestinal niche, belonging to the genera Candida, Cryptococcus, Malassezia, Aspergillus, Saccharomyces, Galactomyces, Trichosporon, and Cladosporium [21]. Recently, through the Human Microbiome Project (HMP), Nash and coworkers (2017) sequenced 317 stool samples in a healthy cohort via Internal Transcribed Spacer 2 (ITS2) region and 18S rRNA gene. The authors reported that gut mycobiota is mainly dominated by Malassezia, Candida, and Saccharomyces, with S. cerevisiae, M. restricta, and C. albicans identified in $9 6 . 8 \%$ , $8 8 . 3 \% $ and $8 0 . 8 \%$ of the samples, respectively [16]. Reports from earlier studies using culture-dependent analysis showed that less than $3 0 \%$ of fungal species are present in the human gut [22, 23]. Collectively, these studies suggest that gut mycobiome is relatively low in diversity as compared to bacterial communities, and the high prevalence of several fungal species identified across samples further suggested that a core mycobiota may exist in the gut.

In the context of fungal development in infants, Schloss and coworkers performed analysis on gut microbiome profile between family members and unrelated subjects and discovered that similar gut microbiome profile are identified in people sharing same life history and environment [24]. A study by Palmer et al. demonstrated that variable levels of fungi were detected from the stool samples of healthy full-term infants after birth and also at defined intervals throughout the first year of life using microarray and PCR analysis. Also, the authors reported the absence of fungal species from the initial stool sample in one of the healthy infants, where the mother of the infant showed detectable fungal levels in the vagina, raising the possibility that vertical transmission (vaginal microbiota) has minimal impact on shaping the fungal colonization in the infant [25]. Bliss et al. had demonstrated vertical and horizontal transmission of $C .$ albicans from mother to infant through DNA fingerprinting techniques [26]. On the other hand, diet could affect the composition of the infant’s mycobiota as well. For instance, Candida species have been identified in breast-feeding women with symptoms of mammary candidiasis [27]. A study by LaTuga et al. identified several fungal species in extremely low birth weight infants in their first postnatal month. These fungal species include S. cerevisiae followed by Candida spp., Cladosporium spp., and Cryptococcus spp. [28]. Another study also reported a lack of fungal diversity and richness in eleven infants using combined NGS technology (targeted on fungal ITS2 amplicons) with qPCR analysis. The most predominant fungi identified in this study were C. albicans, C. parapsilosis, and Leptosphaerulina, with C. albicans being detected in all infants. The authors speculate that the relatively low diversity of fungi in infants as compared to adults could be due to age factor where these infants may not yet been fully colonized by a myriad of different fungal species. Further, the authors highlighted the challenge of detecting low abundance fungi, where low levels of Candida parapsilosis and Candida krusei sequences were detected in a few samples; however, their presence was only detected in one sample via speciesspecific qPCR [29]. On the other hand, a study by Strati et al. demonstrated the influence of age and gender on the gut fungal composition. In this study, the authors reported that infants and children have higher fungal richness than in adults via culture-independent analysis. Meanwhile, the diversity and fungal richness was also higher in female than male healthy subjects [30]. Together, the diversity of fungal composition, the timing and the mechanism involved in assembling fungi into gut microbiome, the influence of genetic and environmental factors in shaping the infant mycobiota, and the contribution of fungi to the microbiome phenotype remain to be explored further.

# 3. Gut Mycobiome and Host Interactions

As discussed previously, gut ecosystem remains a complex environment harboured by various “microscopic” and “macroscopic” organisms. It is believed that the ecosystem in the gut is maintained via multiple interactions among gut members (bacteria, fungi, and virus) as suggested by Filyk and Osborne [31]. On the other hand, accumulated evidences also suggest significant involvement of gut fungi in maintaining host dynamic and the potential of utilizing fungal metabolites in clinical applications. Thus, in this section, we will discuss interaction between fungi with host, deliberate on fungal-bacteria interaction and gut-brain axis, examine the impact of gut fungi on diet and host immunity, and also highlight the influence of gut fungi on health and diseases (Figure 1).

3.1. Fungal-Bacteria Interactions. Generally, the dialogue between fungi and bacteria is studied through the induction of dysbiosis in the gut followed by treatment with either antifungal or antibacterial drugs. It is well known that antibiotics specific to anaerobic bacteria or broad-spectrum antibiotics can have differential impacts on fungal susceptibility, in particular C. albicans [32, 33]. Some studies even suggested that the administration of C. albicans to mice after antibiotic exposure could significantly change the gut microbiome composition, from phyla to family level, and the changes are irreversible in the long run [34, 35]. Further, mycobiome equilibrium is known to have impact on microbiome stability. Such impact is demonstrated in mice model of dextran sulphate sodium- (DSS-) induced colitis. In this model, it was found that the prescription of antifungal drug in the mice had significantly reduced the fungal diversity along with the increase of pathogenic bacterial diversity, which in turn exacerbated the severity of colitis inflammation [36]. On the other hand, a study by Jiang et al. demonstrated that commensal fungi such as C. albicans or S. cerevisiae can functionally replace intestinal bacteria in the event of bacterial dysbiosis after antibiotic exposition. Moreover, these fungal species confer protection against colitis and influenza A virus infection through alleviation of mucosal tissue injuries and host immune modulation [37]. Another robust example of fungal-bacteria interaction is secretion of extracellular enzymes such as phosphatases and proteases by S. boulardii, which aids in deactivating the toxins produced by C. difficile and E. coli [38, 39]. Furthermore, studies had shown that $R .$ gnavus and C. albicans can cause lesion formation in the gut by degrading the protective mucin layer through the action of mucolytic enzymes [40, 41]. Meanwhile, some fatty acid metabolites secreted by bacterial flora also seem to modulate C. albicans germination [42]. A more recent study by García et al. demonstrated that gut microbial metabolites inhibit the invasion of human enterocytes and C. albicans hyphal growth through the target of rapamycin (TOR) signaling pathway [43]. Other than that, interaction between fungal and bacterial cells can cause adverse effects on host via proinflammatory cytokines secretion, which result in apoptotic cell death and oxidative damage on host [44].

Fungi and bacterial cells are also believed to interact with each other within a biofilm habitat, a so called “mixed species biofilm.” Such a habitat can help them to persistently colonize and survive in specific microenvironments such as gut, skin, and oral cavity. Additionally, this “mixed species biofilm” can give extra protection against antimicrobial agents and host immune evasion [45]. Notably, this “mixed species biofilm” provides mutual benefits for both bacterial and fungal cells. Fungi can strengthen their virulence determinants within the biofilm habitat, such as increasing the ability to invade host through hyphal induction and production of extracellular enzymes such as aspartic proteinases. Meanwhile, bacteria may benefit from this habitat via the increase in their resistance towards antimicrobial treatment [45].

![](images/60405a903e94e1ba207126d34000e218b90497a1cd82ec06e21b56c4b13669fe.jpg)  
1: The interactions between gut mycobiome and host in Figurevarious areas.

Kalan et al. had demonstrated a rapid formation of mixed species biofilms between Trichosporon asahii and Staphylococcus simulans or C. albicans and Citrobacter freundii in vitro, revealing a close relation between fungal and bacterial cells [46]. Similarly, Hoarau et al. reported formation of robust biofilm between C. tropicalis, S. marcescens, and E. coli in in vitro biofilm model [47]. Other studies also demonstrated that production of lipopolysaccharides by S. marcescens and E. coli enhanced fungal biofilm maturation [48, 49]. Clearly, there is a strong connection between fungal and bacteria cells. A more in-depth analysis of this interkingdom interaction can provide us with more information on the gut-associated pathogenesis driven by this interaction.

3.2. Mycobiome and Gut-Brain Axis. It is interesting that besides gut microbiome, fungi are involved in the gut-brain axis (GBA). Growing evidences from both clinical and experimental studies suggest that fungi are involved in the bidirectional communication between brain and gut through neuro-immuno-endocrine mediators, which is comparable to microbiome-gut-brain axis [50]. An excellent example of this mycobiome-gut-brain communication is via a study by Botschuijver et al., where the authors investigated the association of intestinal fungal components in patients with inflammatory bowel syndrome (IBS) and in a rat model of visceral hypersensitivity. In the study, the authors observed a mycobiome dysbiosis in the rat model of visceral hypersensitivity, where administration of fungicide, cecal mycobiomes, and soluble $\beta$ -glucans improved hypersensitized rats [51].

3.3. Gut Mycobiome and Immunity. The crosstalk between fungi and host immunity had been extensively reviewed [7, 44]. Of all, Dectin-1 appears as one of the most crucial pattern recognition receptors (PRRs) in shaping fungal immunity [10, 52]. Dectin-1 interacts with $\beta \mathrm { - } 1 , 3$ glucan motif found on the fungal cell walls and elicits host immune response against them. The importance of Dectin-1 has been implicated in the mouse model of DSS-induced colitis where

Dectin-1 knockout mice experienced more severe colitis when compared to wild-type mice. In addition, expansion in Candida and Trichosporon genera and a decrease in Saccharomyces genus, together with increased of proinflammatory cytokines, $\mathrm { I F N } { - \gamma } _ { ; }$ , IL-17, and TNF- $\alpha ,$ also aggravated inflammation in Dectin-1 knockout mice [10]. Further, clinical study has pointed out that polymorphisms in Dectin-1 gene are likely to contribute towards disease exacerbation in patients with ulcerative colitis (UC) [10]. In addition, other evidences also showed that deficiency in Dectin-1 is also linked with increased gastrointestinal colonization with Candida species in patients who received transplants [53, 54]. Taken together, these studies provide evidence on the protective role Dectin-1 in fungal infection and the importance of Dectin-1 to keep fungal in check.

Caspase recruitment domain-containing protein 9 (CARD9), a crucial downstream molecule for antifungal receptors including C-lectin receptors, is also implicated in defense against fungi. In the mice model of colitis, CARD9 knockout mice had increased antifungal antibodies, and the severity of colitis was mitigated upon antifungal treatment, suggesting the protective role of CARD9 signaling against fungi [55]. Meanwhile, IL-17, an effector cytokine for Th-17 helper cells, is involved in the mucosal immune response against fungi. The roles of IL-17 during mucosal fungal infections have been documented in both clinical and animal experimental studies [56–58]. Nevertheless, it remains obscure on the effect of IL-17 on gut mycobiota. One clinical study has reported that higher incidence of fungal infections accompanied with severe intestinal pathology were observed in patients with Crohn’s disease upon IL-17A blockade, indicating the possible role of IL-17 pathway in regulating fungal communities in the gut [59]. A review by Conti et al. also suggested the pertinent role of IL-17 against opportunistic C. albicans [56]. On the other hand, IL-22, a cytokine that is similar to IL-17, is also closely linked with mucosal immunity against fungi. It has been demonstrated that IL-22 regulates gastrointestinal fungi, where mice lacking IL-22 are more prone to gastrointestinal candidiasis upon intragastric challenge with C. albicans [60]. Furthermore, both IL-17 and IL-22 are potent inducers of antimicrobial peptides (AMPs) by epithelial cells, which have indisputable role in clearing mucosal Candida spp. and Aspergillus spp. infections [61–64].

Crosstalk between gut mycobiome and host immune system can modulate the disease outcome. For example, Qamar et al. reported protective effect of Saccharomyces boulardii against Clostridium difficile colitis-induced mice model. In this study, the authors showed that administration of S. boulardii stimulates production of intestinal immunoglobulin A (IgA) against Clostridium difficile toxin A in mice [65]. In another study, Thomas and coworkers reported the antiinflammatory effects of S. boulardii in patients with inflammatory bowel diseases, mainly via inhibition of $\mathrm { T }$ and dendritic cells activation, reduced levels of proinflammatory cytokines including tumor necrosis factor- $\alpha$ and interleukin(IL-) 6 and increase the production of IL-10, which consequently promotes epithelial restitution relevant in IBD [66]. On the other hand, crosstalk between immune system and fungi may influence bacteria in the gut and vice versa. A study by Tang et al. demonstrated that the colon of $_ { \mathrm { C l e c 7 a - } } / -$ mice was protected by Lactobacillus murinusinduced regulatory $\mathrm { T }$ cell expansion in the absence of Candida species. Nevertheless, the presence of C. tropicalis seems to cancel this protective effect and exacerbates intestinal inflammation [67]. Meanwhile, colonization of Candida species as seen in Card9− $\cdot / -$ mice also reduced the populations of tryptophan-metabolizing bacteria, including lactobacilli, which intensify the severity of colitis in Card9−/− mice. The reduction of lactobacilli is accompanied with reduced levels of aryl hydrocarbon receptor (AHR) ligands, Reg3g, Reg3b, and Il22 expression in the colons of Card9− $\cdot / -$ mice [68]. In addition to that, fungal microbiota also helped in shaping the host immune system in regards to the development of colorectal cancer. A recent study by Wang et al. demonstrated the adaptor protein CARD9 confers protection against colon cancer through restriction of Mycobiota-Mediated Expansion of Myeloid-Derived Suppressor Cells (MDSCs) in mice model [69].

Fungal species such as S. cerevisiae and C. albicans are capable of modifying immune response in a significant way. For example, chitin from S. cerevisiae is able to induce “trained immunity (a de facto immune memory of the innate immunity)” in monocytes in a strain dependent manner by increasing cytokine productions such as TNF- $\alpha$ and IL-6 and through direct antimicrobial activity upon stimulation with bacterial, fungal, and TLR ligands [70]. Similarly, C. albicans can induce “trained immunity” along with functional reprogramming of monocytes, which confers protection against reinfection [71]. Taken together, these studies suggest that “trained immunity” is important in maintaining gut immune homeostasis and confer protection on host against invading pathogens.

During gut-brain communication, the effect of intestinal inflammation on the central nervous system is often associated with anxiety, depression, or “sickness behavior” [72]. These psychological behavioral changes are always considered as comorbidities in patients with persistent intestinal inflammation, including inflammatory bowel diseases and irritable bowel diseases [73]. The underlying mechanism could be due to imbalances in serotonergic activity and hyperreactivity of hypothalamic-pituitary-adrenal axis (HPPA) [74, 75]. It is believed that this systemic effect is mediated by host immune factors, especially cytokines including interleukin-6 (IL-6), interleukin- $^ { 1 \beta }$ $( \mathrm { I L - } 1 \beta )$ , and tumor necrosis factor (TNF) [76]. Studies have shown that fungi such as C. albicans, S. cerevisiae, and A. fumigatus are able to modulate cytokine expression, particularly IL-6 [70, 77]. Thus, it is speculated that gut mycobiota may elicit local immune response at the gut site, where these immune mediators, especially cytokines will cross the blood-brain barrier (BBB), and reaching the brain to stimulate specific brain areas, in particular the hypothalamus and circumventricular organs [78].

Meanwhile, there is increasing evidences showing the influence of gut mycobiota on extragastrointestinal organs immune responses. A typical example is through a study by

Wheeler et al., where the authors demonstrated an aggravation of allergic airway disease accompanied with altered gut mycobiota prior to fluconazole administration in mice with DSS-induced colitis. In this study, an expansion of Wallemia sebi, Aspergillus amstelodami, and Epicoccum nigrum and a reduction of Penicillium brevicompactum and C. tropicalis were observed [79]. Meanwhile, McAleer et al. demonstrated the ability of gut microbiota in shaping the pulmonary immune response upon A. fumigatus oropharyngeal challenge. In this study, mice treated with vancomycin for a month had reduced levels of IL-17 and IL-22 and increased the level of IL-4 in the lungs, which indicates the involvement of Th-17 and Th-2 responses against fungi in the lungs [80]. A recent study by Skalski et al. demonstrated that an expansion of Wallemia spp. (W. mellicola) in the gut modified the pulmonary immune response and intensified the airway inflammation in the intratracheal house dust mite (HDM) mice model of allergic airways disease. Additionally, Wallemia was not detected in the lung, suggesting the ability of gastrointestinal colonization of Wallemia to modulate lung immune response remotely. Further analysis of the gut mycobiota revealed that the expansion of W. mellicola in the gut was associated with perturbation in both fungal and bacteria communities [81]. Another study by Li et al. reported that gut fungal dysbiosis induced by fluconazole persistently exacerbates allergic airway disease (AAD) in mice, where this effect is mainly via fungal sensing by gutresident $\mathrm { C X } 3 \mathrm { C R } 1 ^ { + }$ MNPs on peripheral immunity [82]. Overall, these studies revealed a clear link between gut mycobiota, pulmonary immune responses, and lung diseases, which further consolidate the idea of the existence of mycobiota-gut-lung axis.

3.4. Gut Mycobiome and Diet. Diet could be one of the determinants in driving the changes in gut fungal mycobiota composition between individuals. An investigation on the link between diet and fungal mycobiota has been carried out by Hoffmann and his coworkers using culture-independent analysis. In the study, the authors had identified 66 fungal genera, with Candida, Cladosporium, and Saccharomyces being the most common genera identified. The authors speculate that the high prevalence of Saccharomyces could be due to consumption of yeast-containing foods such as beer and bread while high level of Candida was strongly correlated with the recent consumption of carbohydrates. Although this study has identified various fungal communities in the gut, one of the concerns raised in this study is whether these fungal mycobiota identified are permanent residents in the gut or just transient species [19]. Meanwhile, another study had profiled the short-term effect of plant and animal diet on the gut microbiome. In this study, David et al. showed that short-term diet consisting of both animal and plant products alters the microbial community structure. In addition to that, diversified fungal genera including Scopulariopsis, Penicillium, Debaryomyces, and Candida were identified in this study [83]. Moreover, diet therapy and antibiotics seem to reduce the abundance of fungal species in patients with Crohn’s disease, as implicated by Lewis et al. [84]. Collectively, studies on the impact of diet on gut mycobiome are still in its infancy. Nonetheless, more studies are warranted to evaluate and to associate the effect of diet and foodassociated fungi in shaping the diversity, composition, and functionality of human microbiome as well as the effect on diet on gut-associated diseases.

3.5. Gut Mycobiome and Fungal Metabolites. Since the invention of first antibiotic-Penicillin G from Penicillium notatum by Sir Alexander Fleming in 1928, the era of using fungi for medicinal purposes has started. Fungi have shown indispensable role in various areas, including food, biotechnology, and pharmaceutical industries. Fungi also possess great potential in producing a broad spectrum of metabolites, which can be applied for medication or therapeutic purposes. For example, griseofulvin isolated from Penicillium griseofulvum served as antimycotic drug [85], while fusidic acid from Fusidium coccineum [86] and cephalosporins from Acremonium chrysogenum act as antibacterial agents, and lovastatin isolated from Aspergillus terreus and mevastatin from Penicillium citrinum [87] can be used as lipid lowering agents.

Besides this, similar like bacteria, fungi can express metabolites which can influence host homeostasis and exert biological effects on host, as part of fungi-host interactions [17]. Fungal species such as Saccharomyces boulardii, C. albicans, and Saccharomyces cerevisiae may secrete molecules like farnesol, fusel alcohols, tyrosol, and fatty acids, which are autoregulatory molecules of growth. These molecules enable fungal cells to regulate adhesion, yeast-to-hyphae transition and biofilm formation themselves, which in turn facilitate the colonization, invasion, and dissemination in host [88]. On the other hand, polysacharide $\beta 1$ , 3-glucan is a fungal-derived molecule found in the inner cell wall of C. albicans. $\beta 1$ , 3-glucan has strong link with host immunity. A recent study suggested that $\beta 1$ , 3-glucan can trigger “trained immunity” prior to exposure to monocytes, generating more robust immune response upon fungal reinfection. Additionally, $\beta 1$ , 3-glucan can induce epigenetic changes including histone methylation upon exposure to monocytes [71].

Meanwhile, the probiotic yeast Saccharomyces boulardii is able to produce a low molecular weight, water soluble anti-inflammatory factor, which is capable to mediate signal transduction pathway in host cells, such as NF- $\kappa \mathrm { B }$ . It also helps to conserve the tight junction integrity between enterocytes in the small intestine and modulates signal transduction pathway during enteropathogenic E. coli infection [89, 90]. Other than that, Saccharomyces boulardii has been applied in treating various gastrointestinal disorders, as reviewed by Kelesidis. Nonetheless, safety issues concerned with using fungi as probiotics need to be considered, especially in immunocompromised or critically ill patients. These concerns include the possibility of developing fungemia after fungi treatment, gastrointestinal allergic reaction, and the environment risk prior to exposure of fungi in the air [91]. Saccharomyces boulardii may also exert trophic effect on the intestinal enterocytes via endoluminal release of polyamines. A study by Buts et al. reported that daily administration of lyophilized S. boulardii had significantly increased sucrase and maltase activities in rats’ intestines [92]. The actual mechanism remains unknown, but it is likely through the release of spermine and spermidine. Meanwhile, S. boulardii produces a $5 4 \mathrm { k D a }$ serine protease which can directly inhibit Clostridium difficile toxin A in rat ileum and Clostridium difficile toxins A and B in human colonic mucosa [38, 93]. Additionally, it also produces a 63-kDa phosphatase, which degrades Escherichia coli endotoxin by dephosphorylation [39]. Another study also documented the effect of Capric acid produced by S. boulardii in inducing adhesion, yeast-to-hyphae transition, and biofilm formation [94]. Moreover, administration of S. boulardii increases shortchain fatty acids (SCFAs), particularly butyrate, which may confer protective effect in total enteral nutrition- (TEN-) induced diarrhea [95]. Similarly, SCFAs produced by Malassezia species through enzymatic reaction (lipases and phospholipases) on host triglycerides found abundantly on skin could serve as metabolic sources for fungi [96, 97].

Some of the fungal-derived molecules are also known to mediate the interaction between fungal and bacteria. For example, ethanol from Saccharomyces cerevisiae is able to trigger the growth of Acinetobacter (A. baumannii, A. johnsonii, A. haemolyticus, and A. radioresistens) in vitro [98]. Farnesol, a small molecule produced by C. albicans, can also modify quorum sensing regulation in Pseudomonas aeruginosa [99, 100]. This showed that fungi are able to produce assorted secondary metabolites, and more studies can be conducted to shed light on the contribution of fungal metabolites produced in the gut on health and disease.

3.6. Gut Mycobiome and Disease Susceptibility. The significant involvement of fungi in the development and progression of human diseases have been reviewed extensively recently. Often, fungal dysbiosis contributes towards development and progression of several human diseases. A summary of the significant involvement of fungi in human diseases is depicted in Table 1.

3.6.1. Inflammatory Bowel Disease (IBD). Inflammatory bowel disease (IBD) is a group of intestinal diseases characterized by persistent inflammation of the digestive tract. The two most common diseases under IBD include Crohn’s disease (CD) and ulcerative colitis (UC). A number of sources have proven a causal relation between gut mycobiome and IBD. For example, Ott et al. highlighted the differences between IBD with mucosal and fecal microbiota. The authors surmised that there is an alteration in the diversity and composition of fungal microbiota between patients with IBD and controls. However, the authors reported that there are no significant changes between CD and UC [101]. Subsequently, another study by Li et al. demonstrated that fungal dysbiosis in CD are associated with mucosal inflammation in patients with CD. In this study, the authors reported that the feces of patients with CD were characterized by the abundance of Aspergillus clavatus, C. neoformans, and Candida albicans, while Alternaria brassicicola, Gibberella moniliformis, Cryptococcus neoformans, and Candida spp. were reported in the inflamed mucosa [102]. Additionally, the diversity and richness of fungal species identified in this study were associated with the expression of, $\mathrm { I F N } { - \gamma }$ , IL-10, or TNF- $\alpha$ . Meanwhile, a study by Lewis et al. had identified fungal dysbiosis in patients with CD with an increase in Saccharomyces cerevisiae, Cyberlindnera jadinii, Clavispora lusitaniae, Kluyveromyces marxianus, and Candida albicans, accompanied with a change in bacteria composition [84]. A study by Hoarau et al. reported that an expansion of C. tropicalis is found in patients with Crohn’s disease as compared to their healthy relatives. Furthermore, the authors reported a positive correlation between C. tropicalis, S. marcescens, and E. coli, suggesting that an interkingdom microbial interaction could be one of the key determinants in CD development [47]. Meanwhile, Liguori and collaborators showed that global fungus load increased in CD flare, predominantly by Basidiomycota and Ascomycota phyla. Meanwhile, Filobasidium uniguttulatum and Saccharomyces cerevisiae species were correlated with noninflamed mucosa, while Xylariales order was linked with inflamed mucosa [103]. A more recent study by Sokol et al. also revealed the distinctive mycobiome profile between IBD and healthy subjects. The authors reported a spike in Basidiomycota/Ascomycota ratio, accompanied with an expansion of Malassezia sympodialis and C. albicans and a decreased proportion of Saccharomyces cerevisiae in IBD in comparison with healthy controls. This study also highlighted the significant changes in fungal microbiota between remission and relapse stage within IBD cohort. For instance, C. albicans were remarkably increased during relapse when compared to remission stage. Lastly, based on the concomitant analysis of bacterial and fungal microbiota, the authors also suggest that an interkingdom interaction between fungi and bacteria could contribute towards IBD pathogenesis [9]. Hence, modulation of gut mycobiota could be a potential approach in the treatment of IBD [104].

3.6.2. Inflammatory Bowel Syndromes (IBS). Inflammatory bowel syndrome is a functional gastrointestinal disorder associated with altered bowel habits. Few studies have documented the link between IBS and fungal microbiota in the gut. Overall, the representation of fungi in healthy individuals is an insignificant proportion $( \sim 0 . 1 \% )$ of the entire microbiome as reported by various studies, with the three major fungal genera being Saccharomycyes, Candida, and Cladosporium [105]. An earlier study by Levine et al. concluded that overgrowth of Candida species is associated with diarrhea symptom in patients receiving antibacterial therapy [106]. Subsequently, another study documented that patients with antibioticassociated diarrhea have Candida overgrowth in the gastrointestinal tract [107]. Furthermore, Santelmann and Howard reported that “IBS associated symptoms” or “Candida syndrome” could be triggered by Candida products, antigens and cross-antigens [108]. A more recent study by Botschuijver et al. demonstrated fungal dybiosis, predominant by Saccharomyces cerevisiae and Candida albicans in patients with IBS [51]. Taken together, the possible role of fungal microbiota in IBS remains much to explore. Additionally, whether a disruption in bacteria microbiota causes a skewed commensal mycobiota profile in IBS remains a question.

3.6.3. Cancers. The gut mycobiome has been linked with the pathogenesis of colorectal adenoma, an inducer of colorectal cancer (CRC). A recent study by Luan et al. has discerned the role of gut fungi in different stages of colorectal adenoma. In the study, the authors characterized mucosal mycobiota in twenty-seven paired samples of adenomas and adjacent tissues, where Glomeromycota and Basidiomycota phyla dominated both adenomas and adjacent tissues from all subjects. In terms of genera, opportunistic pathogens Phoma and Candida were frequently identified $( 4 5 \% )$ . Also, a decrease in fungal diversity in colorectal adenomas based on operational taxonomic unit (OTU) analysis was recorded [109]. Although the study illustrates the possible role of fungal microbiota in colorectal adenoma development, more studies are warranted to elucidate the cause-effect relationship between fungal microbiota and colorectal cancer. On the other hand, fungal dysbiosis is observed in patients with colorectal cancers and polyps. Additionally, the authors demonstrated that an increase in the Ascomycota/Basidiomycota ratio accompanied with the expansion of opportunistic fungi Trichosporon and Malassezia populations may facilitate the progression of colorectal cancer [110]. Similarly, Coker et al. reported fungal dysbiosis in patients with colorectal cancer. In addition to that, the authors also demonstrated an increase in the Basidiomycota : Ascomycota ratio with enrichment of fungal class Malasseziomycetes and depletion of classes Pneumocystidomycetes and Saccharomycetes were detected [111]. A recent study by Chin et al. has identified the presence of Schizosaccharomyces pombe in the guts of colorectal cancer patients and healthy subjects. The authors discovered that proteins secreted by Schizosaccharomyces pombe were present in high intensity in colorectal cancer patients, with four secreted proteins being closely related with the late stage of colorectal cancer [112]. Collectively, these studies suggest the undisputable role of fungi in colorectal cancer development and provide a new paradigm in utilizing these specific fungal signatures in disease diagnosis or therapeutic approaches.

<html><body><table><tr><td>Disease</td><td>Disease subtypes</td><td>Significant findings that involved fungi</td><td>Reference</td></tr><tr><td>Inflammatory bowel disease</td><td>Crohn&#x27;s disease (CD)</td><td></td><td>[9,47,8,.01-103</td></tr><tr><td> Inflame ory bowel</td><td></td><td>i)s</td><td>[51]</td></tr><tr><td>Cancers</td><td>Colorectal cancer</td><td>(i) Fungal dysbiosis is observed in most of the reported studies</td><td>[109-112]</td></tr><tr><td rowspan="4"></td><td rowspan="4">Hepatitis B</td><td>(i) High levels of Aspergillus, Candida, Galactomyces, Saccharomyces, and</td><td rowspan="4">[11]</td></tr><tr><td>Chaetomium were identified</td></tr><tr><td>(ii) Richness and diversity of fungal species is associated with chronic HBV infection</td></tr><tr><td>(ii) C.albicans,C. krusei,and C.tropicalis were associated with diarrhea in HIV patients</td></tr><tr><td rowspan="5"></td><td rowspan="3">HIV</td><td>(i) C. parvum, C. diffcile,and C. albicans are significantly present in HIV-seropositive patients</td><td>[114] [115]</td></tr><tr><td>(ii) Fungal dysbiosis and high prevalence of Candida species were observed in HIV patients</td><td>[116]</td></tr><tr><td></td><td>[117]</td></tr><tr><td rowspan="3">Obesity</td><td>(i) Candida,Nakaseomyces,and Penicillum genera were commonly identified in obese subjects</td><td rowspan="3">[119]</td></tr><tr><td>(ii) Mucor racemosus and M. fuscus were identified in nonobese patients. (iii) Specific fungal composition could be potentially used to distinguish between</td></tr><tr><td>obese and nonobese patients</td></tr><tr><td rowspan="5"></td><td rowspan="5">Diabetes</td><td></td><td>[123-125]</td></tr><tr><td>)</td><td></td></tr><tr><td>(iii) No difference is found between C. albicans colonization in type 1 and type 2 diabetes.</td><td>[124]</td></tr><tr><td>(iv)ISotifudg surgal seie fFro typel daetes atietis orerestat tars</td><td>[125]</td></tr><tr><td>(i) Phylum Zygomycota, which consists of family Mucoraceae and genus Mucor,</td><td></td></tr><tr><td>Atherosclerosis</td><td></td><td>was negatively correlated with the risk of cardiovascular disease development through carotid intima-media thickness (cIMT) method</td><td>[129]</td></tr><tr><td rowspan="3">Alcoholic liver disease</td><td rowspan="3"></td><td>(i)Ddioh</td><td>[130]</td></tr><tr><td></td><td>[134]</td></tr><tr><td>(i) High abundance of Candida genus were detected</td><td></td></tr><tr><td rowspan="3">Central nervous system diseases</td><td rowspan="3">Autism Spectrum disorder Schizophrenia</td><td>(i) Candida,Malassezia,Aspergillus,and Penicilliun genera were identified</td><td>[135]</td></tr><tr><td>(i) Increased levels of S. cerevisiae and C. albicans species</td><td>[136]</td></tr><tr><td></td><td>[137]</td></tr></table></body></html>

3.6.4. Hepatitis B and HIV Infections. Infectious viruses such as hepatitis B virus and HIV virus, which can affect host immunity, pose the potential to modify the role of other microbes in the gut including fungi, in the context of disease progression and exacerbation. One study characterized the association of fungi in the gut with varying degrees of chronic hepatitis B virus infection via culture-independent and culture-dependent analysis. In this study, Chen et al. reported high prevalence of Aspergillus, Candida, Galactomyces, Saccharomyces, and Chaetomium in patients with hepatitis B. Moreover, the authors surmised that richness and diversity of fungal species in hepatitis B patients are positively correlated with the disease progression in patients with chronic HBV infection [11]. Nevertheless, the positive correlation does not differentiate between cause and effect, which have yet to explored in recent studies.

On the other hand, considerable efforts investigating the relationship between gut mycobiota and HIV are also receiving much attention, as fungal infections often result in diarrhea wasting syndrome, as seen in HIV/AIDS [113]. Jha et al. assessed the clinical and microbiological profile of HIV/AIDS cases in association with diarrhea. The authors discovered that the prevalence of fungi was higher in HIVseropositive patients in comparison with HIV-negative controls. The authors also discovered that C. parvum, C. difficile, and C. albicans are significantly present in HIV-seropositive patients [114]. Similarly, Awoyeni et al. reported an association between candidiasis and HIV patients with diarrhea. The most common species identified in this study were C. albicans, C. krusei, and C. tropicalis [115]. Meanwhile, Gouba and Drancourt also reported a reduction in fungal diversity in HIV-positive patients accompanied with higher prevalence of Candida species [116]. In another study, Esebelahie et al. reported that the prevalence of Candida in HIV patients without antiretroviral treatment was higher than HIV patients with active antiretroviral treatment. The Candida species recovered from the study were C. albicans, C. glabrata, C. krusei, C. tropicalis, and C. parapsilosis [117]. Collectively, these studies suggest that fungal microbiota especially Candida species are associated with the secondary immunodeficiency in HIV-positive patients, in the case of diarrhea and antibiotic treatment.

3.6.5. Obesity. The association between fungi and obesity has been implicated in an obese subject with BMI of 48.9. In this study, an increase in fungal diversity is observed. Additionally, numerous fungi species identified in this study apparently originated from food sources (11 out of 16 fungal species). Nevertheless, the findings in this study may be overrepresented due to only one subject was involved in the study [118]. A recent study involving a higher number of obese subjects $( n = 5 2 )$ ) and controls was conducted. Based on the findings, there is a significant difference in the fungal composition between obese subjects and controls. Nonetheless, Candida, Nakaseomyces, and Penicillium were the most predominant genera identified in obese subjects, whereas Mucor racemosus and $M .$ . fuscus were the most represented in nonobese patients. Additionally, the authors found that Mucor genus was relatively increased in obese subjects upon weight loss. The authors surmise that targeting fungal communities in the gut could be a novel strategy in handling obesity [119].

3.6.6. Diabetes. Micobiome analysis has been performed in a few studies to elucidate the role of microbiota in driving the pathogenesis of diabetes mellitus [120–122]. In the context of fungal involvement, Soyucen and collaborators found that besides Echerichia coli, C. albicans and Enterobacteriaceae colonization were increased in the patients with type 1 diabetes mellitus (T1DM), whereas Bifidobacterium colonization was reduced [123]. Apart from that, Gosiewski et al. measured the quantitative changes of Candida species in both type 1 (T1DM) and type 2 diabetes mellitus (T2DM) patients via real-time PCR (qPCR). From the findings, C. albicans were predominant in the feces of patients with T1DM and T2DM. Nonetheless, there are no significant differences between T1DM and T2DM in terms of C. albicans colonization. Furthermore, the authors observed that the quantity of Candida is negatively correlated with serum lipids in T2DM patients [124]. Likewise, higher fungal species diversity was observed in T1DM with C. albicans being apparently less significant as compared to controls. The discrepancy could be due to greater recovery of fungal diversity in the

T1DM cohort rather than a true reduction of C. albicans levels. Moreover, fungal species isolated from this study were resistant towards antifungal treatment [125]. Collectively, these studies showed that Candida species are more prevalent in patients with diabetes, particularly T1DM. This warrants further studies to elucidate the actual role of Candida in the pathogenesis of T1DM. Meanwhile, the role of gut fungi in T2DM remains much to be explored.

3.6.7. Atherosclerosis. Recently, numerous studies have suggested the association of gut microbiota with the development of atherosclerosis and cardiovascular diseases [126– 128]. Indeed, a recent preliminary study based on cardiovascular risk has documented the possible involvement of gut mycobiota in carotid atherosclerosis. This study recruits thirty-three obese subjects (men and women) where the risk of developing cardiovascular disease was determined through Framingham risk score (FRS) and the carotid intima-media thickness (cIMT). From the study, the authors identified the abundance of the phylum Zygomycota, which consists of family Mucoraceae and genus Mucor showing negative correlation with cIMT. Additionally, M. racemosus was the most prevalent species found in subjects with a low cardiovascular risk profile, and this species was negatively associated with FRS and cIMT. The authors suggest that M. racemosus could be a relevant biomarker for cardiovascular risk [129]. Thus, it seems that mycobiota could have its role in cardiovascular diseases and more studies are needed to unravel the beneficial effects of mycobiota in cardiometabolic diseases.

3.6.8. Alcoholic Liver Disease. The role of gut mycobiota alcohol liver disease has been unraveled in a study involving animal model. In this study, Yang et al. observed an increased in fungal communities and $\beta$ -glucan translocation into systemic circulation in mice after chronic alcohol administration. The authors reported that the effect of $\beta$ -glucan-induced liver inflammation is mainly via C-type lectin-like receptor (CLEC7A) on Kupffer cells, which increases IL- $1 \beta$ expression, promotes hepatocyte damage, and consequently leads to the development of ethanol-induced liver disease. The authors further demonstrated a reduction in intestinal fungal growth and $\beta$ -glucan translocation, followed by alleviation of ethanol-induced liver disease upon antifungal treatments. Meanwhile, the authors observed a decrease in fungal diversity along with Candida overgrowth in alcohol-dependent patients. Further, elevation in immune response against mycobiota was detected in alcoholic cirrhosis patients in comparison with patients with non–alcohol-related cirrhosis and healthy individuals. The authors surmised that chronic alcohol consumption is closely related with changes in gut mycobiota and translocation of fungal products. Thus, the authors suggest that manipulation of gut mycobiota could be an effective intervention for relieving alcohol-related liver disease [130]. A recent review by Szabo commented on the influence of fungal mycobiome on the complexity of alcohol-induced gut-liver axis from multiple aspects and some new insights to unravel the contribution of fungal microbiota between gut and liver in alcoholic liver disease [131].

3.6.9. Neurological Disorders. On the other hand, gut mycobiota is considered as one of the etiological agents in driving the pathophysiology of central nervous diseases (both psychiatric and nonpsychiatric disorders). It is believed that exposure to infectious pathogens at the critical stages of neurodevelopment may deteriorate central nervous system and elicit behavioral anomalies and psychiatric disorders during adulthood [132, 133]. Strati et al. reported dysbiosis in both gut fungal and bacteria microbiota in subjects with Rett syndrome (RTT), a progressive neurological disorder frequently linked with constipation and gastrointestinal dysfunctions. The authors also reported that high abundance of Candida species was detected [134]. Meanwhile, in autism spectrum disorders (ASD), Strati et al. observed an alteration in both fungal and bacteria gut microbiota of ASD patients, with Candida, Malassezia, Aspergillus, and Penicilliun genera commonly identified. Further, the authors even observed an increase in Candida genus in autistic compared to neurotypical subjects in ASD [135]. Meanwhile, several studies suggested that schizophrenia, a psychiatric disorder, is associated with fungal dysbiosis, as portrayed by elevation of S. cerevisiae and C. albicans species [136]. Moreover, Severance et al. also demonstrated the presence of antibody against $C .$ albicans and a robust link between gastrointestinal disturbances with elevated C. albicans in patients with schizophrenia and bipolar disorder, accompanied with lower cognitive scores in these patients [137]. Subsequently, the authors showed that supplementation with a probiotic Lactobacillus rhamnosus and Bifidobacterium animalis greatly improved psychiatric symptoms and normalized blood levels of C. albicans antibodies in schizophrenia [138]. A recent review by Forbes et al. also describes the recent advancement in knowledge regarding gut mycobiome and the plausible role of gut mycobiota in neurological disorders [139].

# 4. Challenges and Future Direction

Numerous sources have proven that gut mycobiota have certain weightage in maintaining host homeostasis. Nevertheless, there remain challenges that hindered the progression of fungal research and in-depth understanding on the fungal community in human. Culture-dependent methods utilizing conventional microbiological techniques, such as biochemical assays [140], microscopy [141], and observation of the fungal growth in culture media (Sabouraud dextrose agar and potato dextrose agar) [142], remain the preference for scientists in resolving the complexity of fungal community in microbial ecosystems. This is due to the fact that culture-dependent methods are inexpensive and cost effective in many laboratories, and alternatives to culture-dependent methods are yet to be developed.

On the other hand, advancement in the molecular era has shifted researchers towards nonculture-dependent methods in microbial community analysis. The approaches such as polymerase chain reaction (PCR) [143] and highthroughput next generation sequencing (NGS) technologies [144, 145] diversified fungal identification and analysis without the need of for complex culturomics [146, 147]. Nevertheless, gold standard methods for cultureindependent analysis to study the complexity of gut mycobiota are still lacking. Recently published data using different molecular approaches such as denaturing gradient gel electrophoresis (DGGE) and cloning [148], qPCR and NGS [29], and NGS alone [149] in gut mycobiome studies raise the concern on the precision of these studies. There is no comparative analysis being undertaken to analyse and to corroborate the findings using nonculture-dependent methods thus far.

Furthermore, the number and significance of fungi in the gut may be underestimated due to several reasons. First, fungal analysis through sequencing efforts and matched with available annotated reference sequences may be underrepresented. Technical problems such as misspellings, poor annotation of fungal database, incomplete representation, and other factors may arise when assigning taxonomy to sequencing reads [150, 151]. Second, the gut fungal composition is influenced by a number of factors, including age, diet, host immunity, medication, host genetics, and also bacterial microbiome through interkingdom interactions [19, 30]. It remains largely unknown to what extent these factors might affect the diversity and stability of gut mycobiota throughout different developmental stages. Third, fungal cell is a substantial mass of biomaterial with its size approximately 100 times larger as compared to a typical bacterial cell, where simple genome-counting numbers may fail to characterize [7]. Lastly, there remain uncultivable fungi yet to discovered, with unknown function and taxonomy [7]. Hopefully, with the advance of culturomics study, the role of uncultivable fungi can be explored, and a full understanding of the fungal compartment in the gut can be attainable.

Although certain fungal species are commensals of human at various body parts, certain “foodborne fungi” or food contamination by fungi pose a serious threat to human health. “Foodborne fungi” illnesses can be caused by fungi from the genera Aspergillus, Alternaria, Fusarium, Candida, and mucormycetes [152–154] or can be due to secondary metabolites such as mycotoxins. An estimation of $6 0 0 ~ \mathrm { { m i l } }$ lion foodborne diseases are reported annually [155], but the disease burden due to mycotoxin and fungus remains largely [156]. Moreover, we still lack a distinctive method to differentiate between foodborne fungi contaminants and commensal fungi that colonize the gut. The only distinguishable characteristic thus far is the visible clinical signs and symptoms often associated with foodborne microbial pathogens whereas the colonizers are often asymptomatic for the individuals that harbor the latter. A review mentioned that surrogate biomarkers such as procalcitonin in addition to the conventional but nonspecific neutrophil count could be used in conjunction with clinical evaluation for identifying infection as opposed to colonization [157]. Frequently, fungal contamination occurs during processing [158, 159], due to improper storage [160, 161], or due to the presence of fungi intrinsically in certain food products [162, 163]. Culturomics and noncultoromics methods are still actively being employed to identify fungi from both sources. Other possible future strategies could exploit the host factors to distinguish between the colonizers and the contaminants, since colonizers often elicit detectable immune responses whereas the colonizers do not cause untoward immune reactions or inflammations. Moreover, an ideal detection method should be developed to identify the presence of foodborne fungi at all stages of food production. As reviewed previously, a good detection tool should satisfy a few criteria such as high specificity and sensitivity, cost-effectiveness, is nonlaborious, and is not time consuming [164, 165].

Clearly, there is a strong connection between gut mycobiota and brain, and the potential of gut mycobiota in driving brain-associated diseases. Indeed, a review by Enaud et al. had proposed possible mechanisms involved in mycobiome-gut-brain axis interaction (GBA) [166]. Further, Candida species appear to be one of the most prevalent species identified in the studies discussed above. This indicates that Candida species could have notable role in the mycobime-GBA. Further studies should focus on the putative role of Candida species in this gut-brain interaction. Additionally, targeting gut mycobiota could be one of the potential intervention strategies to relieve neurological and neuropsychiatric disorders. For example, administration of Saccharomyces boulardii CNCM I-745 had improved intestinal neuromuscular anomalies in IBS-induced mouse model prior to Herpes Simplex Virus type 1 (HSV-1) exposure [167]. A recent study also documented the protective role of mycobiota in reducing inflammation in the central nervous system. In this study, Takata et al. reported that the administration of C. kefyr alleviated the severity of experimental autoimmune encephalomyelitis (EAE), an animal model of multiple sclerosis. The authors surmised that the protection could be due to alteration of bacterial microbiome, accompanied with increase of Tregs and regulatory dendritic cells in mesenteric lymph nodes and diminished production of Thelper 17 cells in the intestinal lamina propria [168].

# 5. Conclusion

From the accumulated evidences, it is clear that gut mycobiome has an indisputable role in host homeostasis and disease development, despite constituting only a small proportion in the gut. Nevertheless, the journey of uncovering the mystery of gut mycobiome must be continued. More multifaceted and multidisciplinary approaches have to be adopted in such a way to identify those uncultivatable or low abundance fungi in the gut, to characterize the fungal species and strain diversity in the gut, and also to differentiate permanent and transient fungal species that reside in the gut. In addition to that, interaction between fungi and their metabolites with various host players (brain, lungs, and host immune system) and xenobiotic components (diets, environments, and others) has to be emphasized, where this could offer new insight into the role of gut mycobiome on host physiology and disease development. Moreover, interkingdom interaction of various fungal species with other members (bacteria, parasite, and virus) present in the gut and how these interactions could affect us are areas to be further explored.

# Conflicts of Interest

The authors declare that they have no conflicts of interest.

# Authors’ Contributions

CVK, CPP, RB, YVC, SAN, and MA conceptualized the idea. CVK and CPP performed literature search, wrote, and revised the manuscript. CVK, YVC, CPP, SAN, RB, and MA revised the manuscript. All authors agreed to the final version of the manuscript.

# Acknowledgments

The study was supported by the Fundamental Research Grant Scheme (FRGS/1/2019/SKK11/TAYLOR/01/1) and (FRGS/1/2019/SKK11/PERDANA/03/1) from Ministry of Education, Malaysia.

# References

[1] J. Qin, M. H. I. T. Consortium, R. Li et al., $^ { \mathrm { e } } \mathrm { A }$ human gut microbial gene catalogue established by metagenomic sequencing,” Nature, vol. 464, no. 7285, pp. 59–65, 2010.   
[2] J. Peterson, S. Garges, M. Giovanni et al., “The NIH human microbiome project,” Genome Research, vol. 19, no. 12, pp. 2317–2323, 2009.   
[3] M. L. Sogin, H. G. Morrison, J. A. Huber et al., “Microbial diversity in the deep sea and the underexplored “rare biosphere”,” Proceedings of the National Academy of Sciences of the United States of America, vol. 103, no. 32, pp. 12115– 12120, 2006.   
[4] L. Cui, A. Morris, and E. Ghedin, “The human mycobiome in health and disease,” Genome Medicine, vol. 5, no. 7, p. 63, 2013.   
[5] D. C. Savage, “Microbial ecology of the gastrointestinal tract,” Annual Review of Microbiology, vol. 31, no. 1, pp. 107–133, 1977.   
[6] M. J. Kennedy, “Regulation of candida albicans populations in the gastrointestinal tract: mechanisms and significance in GI and systemic candidiasis,” in Current topics in medical mycology, M. R. McGinnis and M. Borgers, Eds., pp. 315– 402, Springer, New York, NY, USA, 1989.   
[7] D. M. Underhill and I. D. Iliev, “The mycobiota: interactions between commensal fungi and the host immune system,” Nature Reviews Immunology, vol. 14, no. 6, pp. 405–416, 2014.   
[8] C. E. Huseyin, P. W. O’toole, P. D. Cotter, and P. D. Scanlan, “Forgotten fungi—the gut mycobiome in human health and disease,” Microbiological Reviews, vol. 41, no. 4, pp. 479– 511, 2017.   
[9] H. Sokol, V. Leducq, H. Aschard et al., “Fungal microbiota dysbiosis in IBD,” Gut, vol. 66, no. 6, pp. 1039–1048, 2017.   
[10] I. D. Iliev, V. A. Funari, K. D. Taylor et al., “Interactions between commensal fungi and the C-type lectin receptor Dectin-1 influence colitis,” Science, vol. 336, no. 6086, pp. 1314–1317, 2012.   
[11] Y. Chen, Z. Chen, R. Guo et al., “Correlation between gastrointestinal fungi and varying degrees of chronic hepatitis B virus infection,” Diagnostic Microbiology and Infectious Disease, vol. 70, no. 4, pp. 492–498, 2011.   
[12] M. H. Miceli, J. A. Díaz, and S. A. Lee, “Emerging opportunistic yeast infections,” The Lancet Infectious Diseases, vol. 11, no. 2, pp. 142–151, 2011.   
[13] E. J. Polvi, X. Li, T. R. O’Meara, M. D. Leach, and L. E. Cowen, “Opportunistic yeast pathogens: reservoirs, virulence mechanisms, and therapeutic strategies,” Cellular and Molecular Life Sciences, vol. 72, no. 12, pp. 2261–2287, 2015.   
[14] M. Arumugam, J. Raes, E. Pelletier et al., “Enterotypes of the human gut microbiome,” Nature, vol. 473, no. 7346, pp. 174– 180, 2011.   
[15] H. E. Hallen-Adams and M. J. Suhr, “Fungi in the healthy human gastrointestinal tract,” Virulence, vol. 8, no. 3, pp. 352–358, 2017.   
[16] A. K. Nash, T. A. Auchtung, M. C. Wong et al., “The gut mycobiome of the Human Microbiome Project healthy cohort,” Microbiome, vol. 5, no. 1, p. 153, 2017.   
[17] I. Mogilnicka and M. Ufnal, “Gut mycobiota and fungal metabolites in human homeostasis,” Current Drug Targets, vol. 20, no. 2, pp. 232–240, 2018.   
[18] D. S. Hibbett, M. Binder, J. F. Bischoff et al., “A higher-level phylogenetic classification of the fungi,” Mycological Research, vol. 111, no. 5, pp. 509–547, 2007.   
[19] C. Hoffmann, S. Dollive, S. Grunberg et al., “Archaea and fungi of the human gut microbiome: correlations with diet and bacterial residents,” PLoS One, vol. 8, no. 6, article e66019, 2013.   
[20] Q. Sam, M. Chang, and L. Chai, “The fungal mycobiome and its interaction with gut bacteria in the host,” International Journal of Molecular Sciences, vol. 18, no. 2, p. 330, 2017.   
[21] H. E. Hallen-Adams, S. D. Kachman, J. Kim, R. M. Legge, and I. Martínez, “Fungi inhabiting the healthy human gastrointestinal tract: a diverse and dynamic community,” Fungal Ecology, vol. 15, pp. 9–17, 2015.   
[22] I. Hamad, S. Ranque, E. I. Azhar et al., “Culturomics and amplicon-based metagenomic approaches for the study of fungal population in human gut microbiota,” Scientific Reports, vol. 7, no. 1, pp. 16788–16788, 2017.   
[23] I. Hamad, D. Raoult, and F. Bittar, “Repertory of eukaryotes (eukaryome) in the human gastrointestinal tract: taxonomy and detection methods,” Parasite Immunology, vol. 38, no. 1, pp. 12–36, 2016.   
[24] P. D. Schloss, K. D. Iverson, J. F. Petrosino, and S. J. Schloss, “The dynamics of a family's gut microbiota reveal variations on a theme,” Microbiome, vol. 2, no. 1, 2014.   
[25] C. Palmer, E. M. Bik, D. B. DiGiulio, D. A. Relman, and P. O. Brown, “Development of the human infant intestinal microbiota,” PLoS Biology, vol. 5, no. 7, p. e177, 2007.   
[26] J. M. Bliss, K. P. Basavegowda, W. J. Watson, A. U. Sheikh, and R. M. Ryan, “Vertical and horizontal transmission of Candida albicans in very low birth weight infants using DNA fingerprinting techniques,” The Pediatric Infectious Disease Journal, vol. 27, no. 3, pp. 231–235, 2008.   
[27] W. Mutschlechner, D. Karall, C. Hartmann et al., “Mammary candidiasis: molecular-based detection of Candida species in human milk samples,” European Journal of Clinical Microbiology & Infectious Diseases, vol. 35, no. 8, pp. 1309–1313, 2016.   
[28] M. S. LaTuga, J. C. Ellis, C. M. Cotton et al., “Beyond bacteria: a study of the enteric microbial consortium in extremely low birth weight infants,” PLoS One, vol. 6, no. 12, article e27858, 2011.   
[29] T. Heisel, H. Podgorski, C. M. Staley, D. Knights, M. J. Sadowsky, and C. A. Gale, “Complementary ampliconbased genomic approaches for the study of fungal communities in humans,” PLoS One, vol. 10, no. 2, article e0116705, 2015.   
[30] F. Strati, M. Di Paola, I. Stefanini et al., “Age and gender affect the composition of fungal population of the human gastrointestinal tract,” Frontiers in Microbiology, vol. 7, 2016.   
[31] H. A. Filyk and L. C. Osborne, “The multibiome: the intestinal ecosystem's influence on immune homeostasis, health, and disease,” eBioMedicine, vol. 13, pp. 46–54, 2016.   
[32] J. D. Clark, “Influence of antibiotics or certain intestinal bacteria on orally administered Candida albicans in germ-free and conventional mice,” Infection and Immunity, vol. 4, no. 6, pp. 731–737, 1971.   
[33] G. Samonis, A. Gikas, E. J. Anaissie et al., “Prospective evaluation of effects of broad-spectrum antibiotics on gastrointestinal yeast colonization of humans,” Antimicrobial Agents and Chemotherapy, vol. 37, no. 1, pp. 51–53, 1993.   
[34] K. L. Mason, J. R. Erb Downward, K. D. Mason et al., “Candida albicans and bacterial microbiota interactions in the cecum during recolonization following broad-spectrum antibiotic therapy,” Infection and Immunity, vol. 80, no. 10, pp. 3371–3380, 2012.   
[35] J. R. Erb Downward, N. R. Falkowski, K. L. Mason, R. Muraglia, and G. B. Huffnagle, “Modulation of PostAntibiotic Bacterial Community Reassembly and Host Response by Candida albicans,” Scientific Reports, vol. 3, no. 1, article 2191, 2013.   
[36] X. Qiu, F. Zhang, X. Yang et al., “Changes in the composition of intestinal fungi and their role in mice with dextran sulfate sodium-induced colitis,” Scientific Reports, vol. 5, no. 1, 2015.   
[37] T. T. Jiang, T. Y. Shao, W. X. G. Ang et al., “Commensal fungi recapitulate the protective benefits of intestinal bacteria,” Cell Host & Microbe, vol. 22, no. 6, pp. 809–816.e4, 2017.   
[38] I. Castagliuolo, M. F. Riegler, L. Valenick, J. T. LaMont, and C. Pothoulakis, “Saccharomyces boulardii protease inhibits the effects of Clostridium difficile toxins A and B in human colonic mucosa,” Infection and Immunity, vol. 67, no. 1, pp. 302–307, 1999.   
[39] J.-P. Buts, N. Dekeyser, C. Stilmant, E. Delem, F. Smets, and E. Sokal, “Saccharomyces boulardii Produces in Rat Small Intestine a Novel Protein Phosphatase that Inhibits Escherichia coli Endotoxin by Dephosphorylation,” Pediatric Research, vol. 60, no. 1, pp. 24–29, 2006.   
[40] A. R. Colina, F. Aumont, N. Deslauriers, P. Belhumeur, and L. de Repentigny, “Evidence for degradation of gastrointestinal mucin by Candida albicans secretory aspartyl proteinase,” Infection and Immunity, vol. 64, no. 11, pp. 4514–4519, 1996.   
[41] C. W. Png, S. K. Lindén, K. S. Gilshenan et al., “Mucolytic bacteria with increased prevalence in IBD mucosa augment in vitro utilization of mucin by other bacteria,” The American Journal of Gastroenterology, vol. 105, no. 11, pp. 2420–2428, 2010.   
[42] M. C. Noverr and G. B. Huffnagle, “Regulation of Candida albicans morphogenesis by fatty acid metabolites,” Infection and Immunity, vol. 72, no. 11, pp. 6206–6210, 2004.   
[43] C. García, F. Tebbji, M. Daigneault et al., “The human gut microbial metabolome modulates fungal growth via the TOR signaling pathway,” mSphere, vol. 2, no. 6, 2017.   
[44] I. D. Iliev and I. Leonardi, “Fungal dysbiosis: immunity and interactions at mucosal barriers,” Nature Reviews Immunology, vol. 17, no. 10, pp. 635–646, 2017.   
[45] M. Ghannoum, “Cooperative evolutionary strategy between the bacteriome and mycobiome,” MBio, vol. 7, no. 6, 2016.   
[46] L. Kalan, M. Loesche, B. P. Hodkinson et al., “Redefining the chronic-wound microbiome: fungal communities are prevalent, dynamic, and associated with delayed healing,” MBio, vol. 7, no. 5, 2016.   
[47] G. Hoarau, P. K. Mukherjee, C. Gower-Rousseau et al., “Bacteriome and mycobiome interactions underscore microbial dysbiosis in familial Crohn’s disease,” MBio, vol. 7, no. 5, 2016.   
[48] K. De Brucker, Y. Tan, K. Vints et al., “Fungal $\beta$ -1, 3-glucan increases ofloxacin-tolerance of Escherichia coli in a polymicrobial E. coli–Candida albicans biofilm,” Antimicrobial Agents and Chemotherapy, vol. 59, no. 6, pp. 3052–3058, 2015.   
[49] E. F. Kong, C. Tsui, S. Kucharíková, D. Andes, P. Van Dijck, and M. A. Jabra-Rizk, “Commensal protection of Staphylococcus aureus against antimicrobials by Candida albicans Biofilm matrix,” MBio, vol. 7, no. 5, 2016.   
[50] M. Carabotti, A. Scirocco, M. A. Maselli, and C. Severi, “The gut-brain axis: interactions between enteric microbiota, central and enteric nervous systems,” Annals of Gastroenterology, vol. 28, no. 2, pp. 203–209, 2015.   
[51] S. Botschuijver, G. Roeselers, E. Levin et al., “Intestinal fungal dysbiosis is associated with visceral hypersensitivity in patients with irritable bowel syndrome and rats,” Gastroenterology, vol. 153, no. 4, pp. 1026–1039, 2017.   
[52] D. L. Moyes and J. R. Naglik, “Mucosal immunity and candida albicans infection,” Clinical & Developmental Immunology, vol. 2011, article 346307, 9 pages, 2011.   
[53] T. S. Plantinga, W. J. F. M. van der Velden, B. Ferwerda et al., “Early stop polymorphism in human DECTIN-1 is associated with increased Candida colonization in hematopoietic stem cell transplant recipients,” Clinical Infectious Diseases, vol. 49, no. 5, pp. 724–732, 2009.   
[54] W. J. F. M. van der Velden, M. G. Netea, A. F. J. de Haan, G. A. Huls, J. P. Donnelly, and N. M. A. Blijlevens, “Role of the mycobiome in human acute graft-versus-host disease,” Biology of Blood and Marrow Transplantation, vol. 19, no. 2, pp. 329–332, 2013.   
[55] H. Sokol, K. L. Conway, M. Zhang et al., “Card9 mediates intestinal epithelial cell restitution, T-helper 17 responses, and control of bacterial infection in mice,” Gastroenterology, vol. 145, no. 3, pp. 591–601.e3, 2013.   
[56] H. R. Conti and S. L. Gaffen, “IL-17-mediated immunity to the opportunistic fungal pathogen Candida albicans,” Journal of Immunology, vol. 195, no. 3, pp. 780–788, 2015.   
[57] M. G. Netea, L. A. B. Joosten, J. W. M. van der Meer, B.- J. Kullberg, and F. L. van de Veerdonk, “Immune defence against Candida fungal infections,” Nature Reviews Immunology, vol. 15, no. 10, pp. 630–642, 2015.   
[58] A. Plato, S. E. Hardison, and G. D. Brown, “Pattern recognition receptors in antifungal immunity,” Seminars in Immunopathology, vol. 37, no. 2, pp. 97–106, 2015.   
[59] W. Hueber, B. E. Sands, S. Lewitzky et al., “Secukinumab, a human anti-IL-17A monoclonal antibody, for moderate to severe Crohn’s disease: unexpected results of a randomised, double-blind placebo-controlled trial,” Gut, vol. 61, no. 12, pp. 1693–1700, 2012.   
[60] A. De Luca, T. Zelante, C. D'Angelo et al., “IL-22 defines a novel immune pathway of antifungal resistance,” Mucosal Immunology, vol. 3, no. 4, pp. 361–373, 2010.   
[61] A. Puel, R. Döffinger, A. Natividad et al., “Autoantibodies against IL-17A, IL-17F, and IL-22 in patients with chronic mucocutaneous candidiasis and autoimmune polyendocrine syndrome type I,” The Journal of Experimental Medicine, vol. 207, no. 2, pp. 291–297, 2010.   
[62] M. A. Gessner, J. L. Werner, L. M. Lilly et al., “Dectin-1- dependent interleukin-22 contributes to early innate lung defense against Aspergillus fumigatus,” Infection and Immunity, vol. 80, no. 1, pp. 410–417, 2012.   
[63] A. De Luca, A. Carvalho, C. Cunha et al., “IL-22 and IDO1 affect immunity and tolerance to murine and human vaginal candidiasis,” PLoS Pathogens, vol. 9, no. 7, article e1003486, 2013.   
[64] H. R. Conti, V. M. Bruno, E. E. Childs et al., “IL-17 receptor signaling in oral epithelial cells is critical for protection against oropharyngeal candidiasis,” Cell Host & Microbe, vol. 20, no. 5, pp. 606–617, 2016.   
[65] A. Qamar, S. Aboudola, M. Warny et al., “Saccharomyces boulardii stimulates intestinal immunoglobulin A immune response to Clostridium difficile toxin A in mice,” Infection and Immunity, vol. 69, no. 4, pp. 2762–2765, 2001.   
[66] S. Thomas, D. Metzke, J. Schmitz, Y. Dörffel, and D. C. Baumgart, “Anti-inflammatory effects of Saccharomyces boulardii mediated by myeloid dendritic cells from patients with Crohn’s disease and ulcerative colitis,” American Journal of Physiology. Gastrointestinal and Liver Physiology, vol. 301, no. 6, pp. G1083–G1092, 2011.   
[67] C. Tang, T. Kamiya, Y. Liu et al., “Inhibition of dectin-1 signaling ameliorates colitis by inducing Lactobacillus-mediated regulatory T cell expansion in the intestine,” Cell Host & Microbe, vol. 18, no. 2, pp. 183–197, 2015.   
[68] B. Lamas, M. L. Richard, V. Leducq et al., “CARD9 impacts colitis by altering gut microbiota metabolism of tryptophan into aryl hydrocarbon receptor ligands,” Nature Medicine, vol. 22, no. 6, pp. 598–605, 2016.   
[69] T. Wang, C. Fan, A. Yao et al., “The adaptor protein CARD9 protects against colon cancer by restricting mycobiotamediated expansion of myeloid-derived suppressor cells,” Immunity, vol. 49, no. 3, pp. 504–514.e4, 2018.   
[70] L. Rizzetto, D. C. Ifrim, S. Moretti et al., “Fungal chitin induces trained immunity in human monocytes during cross-talk of the host with Saccharomyces cerevisiae,” The Journal of Biological Chemistry, vol. 291, no. 15, pp. 7961– 7972, 2016.   
[71] J. Quintin, S. Saeed, J. H. A. Martens et al., “Candida albicans infection affords protection against reinfection via functional reprogramming of monocytes,” Cell Host & Microbe, vol. 12, no. 2, pp. 223–232, 2012.   
[72] R. Dantzer, J. P. Konsman, R. M. Bluthé, and K. W. Kelley, “Neural and humoral pathways of communication from the immune system to the brain: parallel or convergent?,” Autonomic Neuroscience, vol. 85, no. 1-3, pp. 60– 65, 2000.   
[73] L. A. Graff, J. R. Walker, and C. N. Bernstein, “Depression and anxiety in inflammatory bowel disease: a review of comorbidity and management,” Inflammatory Bowel Diseases, vol. 15, no. 7, pp. 1105–1118, 2009.   
[74] G. Clarke, E. M. M. Quigley, J. F. Cryan, and T. G. Dinan, “Irritable bowel syndrome: towards biomarker identification,” Trends in Molecular Medicine, vol. 15, no. 10, pp. 478–489, 2009.   
[75] S. El Aidy, T. G. Dinan, and J. F. Cryan, “Immune modulation of the brain-gut microbe axis,” Frontiers in Microbiology, vol. 5, 2014.   
[76] A. J. Dunn, “Effects of cytokines and infections on brain neurochemistry,” Clinical Neuroscience Research, vol. 6, no. 1-2, pp. 52–68, 2006.   
[77] K. Czakai, I. Leonhardt, A. Dix et al., “Kruppel-like Factor 4 modulates interleukin-6 release in human dendritic cells after in vitro stimulation with Aspergillus fumigatus and Candida albicans,” Scientific Reports, vol. 6, no. 1, article 27990, 2016.   
[78] S. El Aidy, T. G. Dinan, and J. F. Cryan, “Immune modulation of the brain-gut-microbe axis,” Frontiers in Microbiology, vol. 5, 2014.   
[79] M. L. Wheeler, J. J. Limon, A. S. Bar et al., “Immunological consequences of intestinal fungal dysbiosis,” Cell Host & Microbe, vol. 19, no. 6, pp. 865–873, 2016.   
[80] J. P. McAleer, N. L. H. Nguyen, K. Chen et al., “Pulmonary Th17 antifungal immunity is regulated by the gut microbiome,” Journal of Immunology, vol. 197, no. 1, pp. 97–107, 2016.   
[81] J. H. Skalski, J. J. Limon, P. Sharma et al., “Expansion of commensal fungus Wallemia mellicola in the gastrointestinal mycobiota enhances the severity of allergic airway disease in mice,” PLoS Pathogens, vol. 14, no. 9, article e1007260, 2018.   
[82] X. Li, I. Leonardi, A. Semon et al., “Response to fungal dysbiosis by gut-resident $\mathrm { C X } 3 \mathrm { C R } 1 ^ { + }$ mononuclear phagocytes aggravates allergic airway disease,” Cell Host & Microbe, vol. 24, no. 6, pp. 847–856.e4, 2018.   
[83] L. A. David, C. F. Maurice, R. N. Carmody et al., “Diet rapidly and reproducibly alters the human gut microbiome,” Nature, vol. 505, no. 7484, pp. 559–563, 2014.   
[84] J. D. Lewis, E. Z. Chen, R. N. Baldassano et al., “Inflammation, antibiotics, and diet as environmental stressors of the gut microbiome in pediatric Crohn’s disease,” Cell Host & Microbe, vol. 18, no. 4, pp. 489–500, 2015.   
[85] H. Banani, M. Marcet-Houben, A. R. Ballester et al., “Genome sequencing and secondary metabolism of the postharvest pathogen Penicillium griseofulvum,” BMC Genomics, vol. 17, no. 1, 2016.   
[86] M. M. Curbete and H. R. N. Salgado, “A critical review of the properties of fusidic acid and analytical methods for its determination,” Critical Reviews in Analytical Chemistry, vol. 46, no. 4, pp. 352–360, 2016.   
[87] M. Manzoni and M. Rollini, “Biosynthesis and biotechnological production of statins by filamentous fungi and application of these cholesterol-lowering drugs,” Applied Microbiology and Biotechnology, vol. 58, no. 5, pp. 555–564, 2002.   
[88] J. Shareck and P. Belhumeur, “Modulation of morphogenesis in Candida albicans by various small molecules,” Eukaryotic Cell, vol. 10, no. 8, pp. 1004–1012, 2011.   
[89] D. Czerucka, S. Dahan, B. Mograbi, B. Rossi, and P. Rampal, “Saccharomyces boulardii preserves the barrier function and modulates the signal transduction pathway induced in enteropathogenic Escherichia coli-infected T84 cells,” Infection and Immunity, vol. 68, no. 10, pp. 5998– 6004, 2000.   
[90] S. Sougioultzis, S. Simeonidis, K. R. Bhaskar et al., “Saccharomyces boulardii produces a soluble anti-inflammatory factor that inhibits NF- $\mathbf { \sigma } \cdot \kappa \mathbf { B }$ -mediated IL-8 gene expression,” Biochemical and Biophysical Research Communications, vol. 343, no. 1, pp. 69–76, 2006.   
[91] T. Kelesidis and C. Pothoulakis, “Efficacy and safety of the probiotic Saccharomyces boulardii for the prevention and therapy of gastrointestinal disorders,” Therapeutic Advances in Gastroenterology, vol. 5, no. 2, pp. 111–125, 2012.   
[92] J.-P. Buts, N. D. Keyser, and L. D. Raedemaeker, “Saccharomyces boulardii Enhances Rat Intestinal Enzyme Expression by Endoluminal Release of Polyamines,” Pediatric Research, vol. 36, no. 4, pp. 522–527, 1994.   
[93] I. Castagliuolo, J. T. LaMont, S. T. Nikulasson, and C. Pothoulakis, “Saccharomyces boulardii protease inhibits Clostridium difficile toxin A effects in the rat ileum,” Infection and Immunity, vol. 64, no. 12, pp. 5225–5232, 1996.   
[94] A. Murzyn, A. Krasowska, P. Stefanowicz, D. Dziadkowiec, and M. Łukaszewicz, “Capric acid secreted by S. boulardii inhibits C. albicans filamentous growth, adhesion and biofilm formation,” PLoS One, vol. 5, no. 8, article e12050, 2010.   
[95] S. M. Schneider, F. Girard-Pipau, J. Filippi et al., “Effects of Saccharomyces boulardii on fecal short-chain fatty acids and microflora in patients on long-term total enteral nutrition,” World Journal of Gastroenterology, vol. 11, no. 39, pp. 6165–6169, 2005.   
[96] A. Velegraki, C. Cafarchia, G. Gaitanis, R. Iatta, and T. Boekhout, “Malassezia infections in humans and animals: pathophysiology, detection, and treatment,” PLoS Pathogens, vol. 11, no. 1, article e1004523, 2015.   
[97] T. C. White, K. Findley, T. L. Dawson et al., “Fungi on the skin: dermatophytes and Malassezia,” Cold Spring Harbor Perspectives in Medicine, vol. 4, no. 8, 2014.   
[98] M. G. Smith, S. G. Des Etages, and M. Snyder, “Microbial synergy via an ethanol-triggered pathway,” Molecular and Cellular Biology, vol. 24, no. 9, pp. 3874–3884, 2004.   
[99] C. Cugini, M. W. Calfee, J. M. Farrow, D. K. Morales, E. C. Pesci, and D. A. Hogan, “Farnesol, a common sesquiterpene, inhibits PQS production in Pseudomonas aeruginosa,” Molecular Microbiology, vol. 65, no. 4, pp. 896–906, 2007.   
[100] A. Y. Peleg, D. A. Hogan, and E. Mylonakis, “Medically important bacterial-fungal interactions,” Nature Reviews Microbiology, vol. 8, no. 5, pp. 340–349, 2010.   
[101] S. J. Ott, T. Kühbacher, M. Musfeldt et al., “Fungi and inflammatory bowel diseases: alterations of composition and diversity,” Scandinavian Journal of Gastroenterology, vol. 43, no. 7, pp. 831–841, 2008.   
[102] Q. Li, C. Wang, C. Tang, Q. He, N. Li, and J. Li, “Dysbiosis of gut fungal microbiota is associated with mucosal inflammation in Crohn’s disease,” Journal of Clinical Gastroenterology, vol. 48, no. 6, pp. 513–523, 2014.   
[103] G. Liguori, B. Lamas, M. L. Richard et al., “Fungal dysbiosis in mucosa-associated microbiota of Crohn’s disease patients,” Journal of Crohn's & Colitis, vol. 10, no. 3, pp. 296–305, 2016.   
[104] S. Lam, T. Zuo, M. Ho, F. K. L. Chan, P. K. S. Chan, and S. C. Ng, “Review article: Fungal alterations in inflammatory bowel diseases,” Alimentary Pharmacology & Therapeutics, vol. 50, no. 11-12, pp. 1159–1171, 2019.   
[105] P. P. Chong, V. K. Chin, C. Y. Looi, W. F. Wong, P. Madhavan, and V. C. Yong, “The microbiome and irritable bowel syndrome – a review on the pathophysiology, current research and future therapy,” Frontiers in Microbiology, vol. 10, article 1136, 2019.   
[106] J. Levine, R. K. Dykoski, and E. N. Janoff, “Candida-associated diarrhea: a syndrome in search of credibility,” Clinical Infectious Diseases, vol. 21, no. 4, pp. 881–886, 1995.   
[107] R. Krause and E. C. Reisinger, “Candida and antibioticassociated diarrhoea,” Clinical Microbiology and Infection, vol. 11, no. 1, pp. 1-2, 2005.   
[108] H. Santelmann and J. M. Howard, “Yeast metabolic products, yeast antigens and yeasts as possible triggers for irritable bowel syndrome,” European Journal of Gastroenterology & Hepatology, vol. 17, no. 1, pp. 21–26, 2005.   
[109] C. Luan, L. Xie, X. Yang et al., “Dysbiosis of fungal microbiota in the intestinal mucosa of patients with colorectal adenomas,” Scientific Reports, vol. 5, no. 1, article 7980, 2015.   
[110] R. Gao, C. Kong, H. Li et al., “Dysbiosis signature of mycobiota in colon polyp and colorectal cancer,” European Journal of Clinical Microbiology & Infectious Diseases, vol. 36, no. 12, pp. 2457–2468, 2017.   
[111] O. O. Coker, G. Nakatsu, R. Z. Dai et al., “Enteric fungal microbiota dysbiosis and ecological alterations in colorectal cancer,” Gut, vol. 68, no. 4, pp. 654–662, 2019.   
[112] S. F. Chin, P. I. H. Megat Mohd Azlan, L. Mazlan, and H. M. Neoh, “Identification of Schizosaccharomyces pombe in the guts of healthy individuals and patients with colorectal cancer: preliminary evidence from a gut microbiome secretome study,” Gut Pathogens, vol. 10, no. 1, p. 29, 2018.   
[113] B. Kashyap, P. Bhalla, and B. Uppal, “Enteric pathogens in HIV/AIDS from a tertiary care hospital,” Indian Journal of Community Medicine, vol. 34, no. 3, pp. 237–242, 2009.   
[114] A. K. Jha, B. Uppal, S. Chadha et al., “Clinical and microbiological profile of HIV/AIDS cases with diarrhea in North India,” Journal of Pathogens, vol. 2012, Article ID 971958, 7 pages, 2012.   
[115] A. Awoyeni, O. Olaniran, B. Odetoyin et al., “Isolation and evaluation of Candida species and their association with $\mathrm { C D 4 } ^ { + }$ T cells counts in HIV patients with diarrhoea,” African Health Sciences, vol. 17, no. 2, pp. 322–329, 2017.   
[116] N. Gouba and M. Drancourt, “Digestive tract mycobiota: a source of infection,” Médecine et Maladies Infectieuses, vol. 45, no. 1-2, pp. 9–16, 2015.   
[117] N. O. Esebelahie, I. B. Enweani, and R. Omoregie, “Candida colonisation in asymptomatic HIV patients attending a tertiary hospital in Benin City, Nigeria,” Libyan Journal of Medicine, vol. 8, no. 1, article 20322, 2013.   
[118] N. Gouba, D. Raoult, and M. Drancourt, “Plant and fungal diversity in gut microbiota as revealed by molecular and culture investigations,” PLoS One, vol. 8, no. 3, article e59474, 2013.   
[119] M. Mar Rodríguez, D. Pérez, F. Javier Chaves et al., “Obesity changes the human gut mycobiome,” Scientific Reports, vol. 5, no. 1, article 14600, 2015.   
[120] A. Paun, C. Yau, and J. S. Danska, “The influence of the microbiome on type 1 diabetes,” Journal of Immunology, vol. 198, no. 2, pp. 590–595, 2017.   
[121] H. Han, Y. Li, J. Fang et al., “Gut microbiota and type 1 diabetes,” International Journal of Molecular Sciences, vol. 19, no. 4, p. 995, 2018.   
[122] N. G. Vallianou, T. Stratigou, and S. Tsagarakis, “Microbiome and diabetes: where are we now?,” Diabetes Research and Clinical Practice, vol. 146, pp. 111–118, 2018.   
[123] E. Soyucen, A. Gulcan, A. C. Aktuglu-Zeybek, H. Onal, E. Kiykim, and A. Aydin, “Differences in the gut microbiota of healthy children and those with type 1 diabetes,” Pediatrics International, vol. 56, no. 3, pp. 336–343, 2014.   
[124] T. Gosiewski, D. Salamon, M. Szopa, A. Sroka, M. T. Malecki, and M. Bulanda, “Quantitative evaluation of fungi of the genus Candida in the feces of adult patients with type 1 and 2 diabetes - a pilot study,” Gut Pathogens, vol. 6, no. 1, p. 43, 2014.   
[125] B. Kowalewska, K. Zorena, M. Szmigiero-Kawko, P. Wąż, and M. Myśliwiec, “Higher diversity in fungal species discriminates children with type 1 diabetes mellitus from healthy control,” Patient Preference and Adherence, vol. 10, pp. 591–599, 2016.   
[126] Z. Jie, H. Xia, S. L. Zhong et al., “The gut microbiome in atherosclerotic cardiovascular disease,” Nature Communications, vol. 8, no. 1, p. 845, 2017.   
[127] W. H. W. Tang, T. Kitai, and S. L. Hazen, “Gut microbiota in cardiovascular health and disease,” Circulation Research, vol. 120, no. 7, pp. 1183–1196, 2017.   
[128] N. Yoshida, T. Yamashita, and K. I. Hirata, “Gut microbiome and cardiovascular diseases,” Diseases, vol. 6, no. 3, p. 56, 2018.   
[129] M. R. Chacón, J. Lozano-Bartolomé, M. Portero-Otín et al., “The gut mycobiome composition is linked to carotid atherosclerosis,” Beneficial Microbes, vol. 9, no. 2, pp. 185–198, 2018.   
[130] A. M. Yang, T. Inamine, K. Hochrath et al., “Intestinal fungi contribute to development of alcoholic liver disease,” The Journal of Clinical Investigation, vol. 127, no. 7, pp. 2829– 2841, 2017.   
[131] G. Szabo, “Gut-liver axis beyond the microbiome: how the fungal mycobiome contributes to alcoholic liver disease,” Hepatology, vol. 68, no. 6, pp. 2426–2428, 2018.   
[132] I. Knuesel, L. Chicha, M. Britschgi et al., “Maternal immune activation and abnormal brain development across CNS disorders,” Nature Reviews Neurology, vol. 10, no. 11, pp. 643– 660, 2014.   
[133] M. A. Labouesse, W. Langhans, and U. Meyer, “Long-term pathological consequences of prenatal infection: beyond brain disorders,” American Journal of Physiology. Regulatory, Integrative and Comparative Physiology, vol. 309, no. 1, pp. R1–R12, 2015.   
[134] F. Strati, D. Cavalieri, D. Albanese et al., “Altered gut microbiota in Rett syndrome,” Microbiome, vol. 4, no. 1, p. 41, 2016.   
[135] F. Strati, D. Cavalieri, D. Albanese et al., “New evidences on the altered gut microbiota in autism spectrum disorders,” Microbiome, vol. 5, no. 1, p. 24, 2017.   
[136] E. G. Severance, A. Alaedini, S. Yang et al., “Gastrointestinal inflammation and associated immune activation in schizophrenia,” Schizophrenia Research, vol. 138, no. 1, pp. 48–53, 2012.   
[137] E. G. Severance, K. L. Gressitt, C. R. Stallings et al., “Candida albicans exposures, sex specificity and cognitive deficits in schizophrenia and bipolar disorder,” NPJ Schizophrenia, vol. 2, no. 1, article 16018, 2016.   
[138] E. G. Severance, K. L. Gressitt, C. R. Stallings et al., “Probiotic normalization of Candida albicans in schizophrenia: a randomized, placebo-controlled, longitudinal pilot study,” Brain, Behavior, and Immunity, vol. 62, pp. 41–45, 2017.   
[139] J. D. Forbes, C. N. Bernstein, H. Tremlett, G. van Domselaar, and N. C. Knox, “A fungal world: could the gut mycobiome be involved in neurological disease?,” Frontiers in Microbiology, vol. 9, article 3249, 2019.   
[140] R. Khatib, K. M. Riederer, J. Ramanathan, and J. Baran, “Faecal fungal flora in healthy volunteers and inpatients,” Mycoses, vol. 44, no. 5, pp. 151–156, 2001.   
[141] L. de Repentigny, M. Phaneuf, and L. G. Mathieu, “Gastrointestinal colonization and systemic dissemination by Candida albicans and Candida tropicalis in intact and immunocompromised mice,” Infection and Immunity, vol. 60, no. 11, pp. 4907–4914, 1992.   
[142] A. Ouanes, A. Kouais, S. Marouen, M. Sahnoun, B. Jemli, and S. Gargouri, “Contribution of the chromogenic medium CHROMagar® Candida in mycological diagnosis of yeasts,” Journal de Mycologie Médicale, vol. 23, no. 4, pp. 237–241, 2013.   
[143] F. Sanger, S. Nicklen, and A. R. Coulson, “DNA sequencing with chain-terminating inhibitors,” Proceedings of the National Academy of Sciences of the United States of America, vol. 74, no. 12, pp. 5463–5467, 1977.   
[144] E. R. Mardis, “Next-generation sequencing platforms,” Annual Review of Analytical Chemistry, vol. 6, no. 1, pp. 287–303, 2013.   
[145] J. Zoll, E. Snelders, P. E. Verweij, and W. J. G. Melchers, “Next-generation sequencing in the mycology lab,” Current Fungal Infection Reports, vol. 10, no. 2, pp. 37–42, 2016.   
[146] C. Landlinger, L. Bašková, S. Preuner, B. Willinger, V. Buchta, and T. Lion, “Identification of fungal species by fragment length analysis of the internally transcribed spacer 2 region,” European Journal of Clinical Microbiology & Infectious Diseases, vol. 28, no. 6, pp. 613–622, 2009.   
[147] S. Shokralla, J. L. Spall, J. F. Gibson, and M. Hajibabaei, “Next-generation sequencing technologies for environmental DNA research,” Molecular Ecology, vol. 21, no. 8, pp. 1794– 1805, 2012.   
[148] P. D. Scanlan and J. R. Marchesi, “Micro-eukaryotic diversity of the human distal gut microbiota: qualitative assessment using culture-dependent and -independent analysis of faeces,” The ISME Journal, vol. 2, no. 12, pp. 1183–1193, 2008.   
[149] J. Tang, I. D. Iliev, J. Brown, D. M. Underhill, and V. A. Funari, “Mycobiome: approaches to analysis of intestinal fungi,” Journal of Immunological Methods, vol. 421, pp. 112–121, 2015.   
[150] M. J. Suhr and H. E. Hallen-Adams, “The human gut mycobiome: pitfalls and potentials—a mycologist’s perspective,” Mycologia, vol. 107, no. 6, pp. 1057–1073, 2016.   
[151] B. Halwachs, N. Madhusudhan, R. Krause et al., “Critical issues in mycobiota analysis,” Frontiers in Microbiology, vol. 8, p. 180, 2017.   
[152] A. Tomsíková, “Risk of fungal infection from foods, particularly in immunocompromised patients,” Epidemiol Mikrobiol Imunol, vol. 51, no. 2, pp. 78–81, 2002.   
[153] M. P. Brenier-Pinchart, O. Faure, F. Garban et al., “Ten-year surveillance of fungal contamination of food within a protected haematological unit,” Mycoses, vol. 49, no. 5, pp. 421–425, 2006.   
[154] J. I. Pitt and A. D. Hocking, Fungi and Food Spoilage, Springer, New York, 3 edition, 2009.   
[155] [WHO] World Health Organization, “WHO estimates of the global burden of foodborne diseases,” 2015, http://apps.who .int/iris/bitstream/10665/199350/1/9789241565165_eng.pdf.   
[156] A. G. Marroquin-Cardona, N. M. Johnson, T. D. Phillips, and A. W. Hayes, “Mycotoxins in a changing global environment – A review, ” Food and Chemical Toxicology, vol. 69, pp. 220 – 230, 2014.   
[157] R. G. Wunderink, “Surrogate markers and microbiologic end points, ” Clinical Infectious Diseases, vol. 51, no. S1, pp. S126 – S130, 2010.   
[158] S. P. Lazar, J. M. Lukaszewicz, K. A. Persad, and J. F. Reinhardt, “Rhinocerebral Mucor circinelloides infection in immunocompromised patient following yogurt ingestion, ” Delaware Medical Journal, vol. 86, no. 8, pp. 245 –248, 2014.   
[159] S. Vallabhaneni, T. A. Walker, S. R. Lockhart et al., “Notes from the field: fatal gastrointestinal mucormycosis in a premature infant associated with a contaminated dietary supplement—Connecticut, 2014,” MMWR, vol. 64, no. 6, pp. 155- 156, 2015.   
[160] C. A. Aboltins, W. A. B. Pratt, and T. R. Solano, “Fungemia secondary to gastrointestinal Mucor indicus infection, ” Clinical Infectious Diseases, vol. 42, no. 1, pp. 154-155, 2006.   
[161] M. Gurgui, F. Sanchez, F. March et al., “Nosocomial outbreak of Blastoschizomyces capitatus associated with contaminated milk in a haematological unit, ” Journal of Hospital Infection , vol. 78, no. 4, pp. 274 –278, 2011.   
[162] J. C. Sutherland and T. H. Jones, “Gastric mucormycosis: report of case in a Swazi, ” South African Medical Journal , vol. 34, p. 161, 1960.   
[163] M. Radosavljevic, H. ́. ̀. Koenig, V. ́. Letscher-Bru et al., “Candida catenulata fungemia in a cancer patient,” Journal of Clinical Microbiology, vol. 37, no. 2, pp. 475 –477, 1999.   
[164] K. Benedict, T. M. Chiller, and R. K. Mody, “Invasive fungal infections acquired from contaminated food or nutritional supplements: a review of the literature, ” Foodborne Pathogens and Disease, vol. 13, no. 7, pp. 343 –349, 2016.   
[165] B. Priyanka, R. K. Patil, and S. Dwarakanath, “A review on detection methods used for foodborne pathogens, ” Indian Journal of Medical Research, vol. 144, no. 3, pp. 327 –338, 2016.   
[166] R. Enaud, L. E. Vandenborght, N. Coron et al., “The mycobiome: a neglected component in the microbiota-gut-brain axis, ” Microorganisms, vol. 6, no. 1, p. 22, 2018.   
[167] P. Brun, M. Scarpa, C. Marchiori et al., “Saccharomyces boulardii CNCM I-745 supplementation reduces gastrointestinal dysfunction in an animal model of IBS, ” PLoS One, vol. 12, no. 7, article e0181863, 2017.   
[168] K. Takata, T. Tomita, T. Okuno et al., “Dietary yeasts reduce in flammation in central nerve system via micro flora, ” Annals of Clinical Translational Neurology, vol. 2, no. 1, pp. 56 –66, 2015.